#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{
	[TestFixture]
	public class BOL_OrderedUnit : BaseTest 
	{

		private OrderedUnit _orderedUnit;
		private Guid _patientGuid;
		private Guid _orderedComponentGuid;
		private Guid _orderedUnitGuid;
		private Guid _bloodUnitGuid;
		private Guid _patientSpecimenGuid;
		private byte[] _rowVersion;
		private string _releaseTechId;
		private ArrayList _assignedUnits;
		

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				string sSQL2 = "SELECT TOP 1 OU.OrderedUnitGuid, OU.RowVersion, OU.BloodUnitGuid, OC.OrderedComponentGuid, PT.PatientGuid, OC.PatientSpecimenGuid FROM OrderedUnit OU " + 
								"JOIN	OrderedComponent OC on OU.OrderedComponentGUID = OC.OrderedComponentGUID " +
								"JOIN	PatientOrder PO on OC.PatientOrderGUID = PO.PatientOrderGUID " +
								"JOIN	PatientTreatment PT on PO.PatientTreatmentGUID = PT.PatientTreatmentGUID " +
								"JOIN	Patient P ON PT.PatientGUID = P.PatientGUID " +
								"WHERE  OU.RecordStatusCode = 'A' AND OC.PatientSpecimenGuid IS NOT NULL AND OU.ReleaseDate IS NULL AND OU.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'" ;


				// build the sql query string
				string sSQL = "SELECT TOP 1 PT.PatientGuid, OC.OrderedComponentGuid, OU.OrderedUnitGuid, " +
					"OU.BloodUnitGuid, OU.DivisionCode, PS.PatientSpecimenGUID, OU.RowVersion "+
					"FROM OrderedUnit OU " +
					"JOIN OrderedComponent OC ON OC.OrderedComponentGUID = OU.OrderedComponentGUID " +
					"JOIN PatientOrder PO ON OC.PatientOrderGUID = PO.PatientOrderGUID " +
					"JOIN PatientTreatment PT ON PT.PatientTreatmentGUID = PO.PatientTreatmentGUID " +
					"JOIN PatientSpecimen PS ON OC.PatientSpecimenGUID = PS.PatientSpecimenGUID " +
					"JOIN vw_BloodShipAllCurrent VW ON OU.BloodUnitGuid = VW.BloodUnitGuid " +
					"WHERE OC.PatientSpecimenGuid IS NOT NULL " +
					"AND VW.UnitStatusCode IN ('S','C') " +
					"AND OU.DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'";

				DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable(sSQL2, true);

				_patientGuid =			 (Guid)	dtTemp.Rows[0][TABLES.PatientTreatment.PatientGuid];
				_orderedComponentGuid =  (Guid)	dtTemp.Rows[0][TABLES.OrderedComponent.OrderedComponentGuid];
				_orderedUnitGuid =		 (Guid) dtTemp.Rows[0][TABLES.OrderedUnit.OrderedUnitGuid];
				_bloodUnitGuid =	     (Guid)	dtTemp.Rows[0][TABLES.OrderedUnit.BloodUnitGuid];
				_patientSpecimenGuid =	 (Guid) dtTemp.Rows[0][TABLES.PatientSpecimen.PatientSpecimenGuid];
				_rowVersion =			 (byte[]) dtTemp.Rows[0][TABLES.OrderedUnit.RowVersion];
				_releaseTechId =		 Common.LogonUser.LogonUserName;

				this.RefreshData = false;
			}

			_orderedUnit = new gov.va.med.vbecs.BOL.OrderedUnit();

		}


		#region constructors

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsNotNull(_orderedUnit);
			Assert.AreEqual(_orderedUnit,_orderedUnit);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}


		[Test]
		public void Ctor_DataRow_Pass()
		{
			DataTable dt = BOL.OrderedUnit.GetOrderedUnit(_bloodUnitGuid, UnitTestConfig.TestDivisionCode);
			if (dt.Rows.Count > 0)
			{
				_orderedUnit = new BOL.OrderedUnit(dt.Rows[0]);
				Assert.IsNotNull(_orderedUnit);
				Assert.AreEqual(_orderedUnit,_orderedUnit);
				
			}
			else
			{
				Assert.Fail();
			}
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void Ctor_DataRow_Fail()
		{
			DataTable dt = BOL.OrderedUnit.GetOrderedUnit(_bloodUnitGuid, UnitTestConfig.TestDivisionCode);
			DataRow dr = dt.NewRow();
			dr = null;
			
			_orderedUnit = new BOL.OrderedUnit(dr);
		}

		[Test]
		public void Ctor_Guid_String_Bool_Pass()
		{
			_orderedUnit = new BOL.OrderedUnit(_orderedUnitGuid, UnitTestConfig.TestDivisionCode, true);
			Assert.IsNotNull(_orderedUnit);
			Assert.AreEqual(_orderedUnit,_orderedUnit);				
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void Ctor_Guid_String_Bool_Fail()
		{
			_orderedUnit = new BOL.OrderedUnit(Guid.Empty, string.Empty, false);
		}

		[Test]
		public void Ctor_Guid_Guid_Pass()
		{
			_orderedUnit = new BOL.OrderedUnit(_bloodUnitGuid, _patientGuid);
			Assert.IsNotNull(_orderedUnit);
			Assert.AreEqual(_orderedUnit,_orderedUnit);				
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void Ctor_Guid_Guid_Fail()
		{
			_orderedUnit = new BOL.OrderedUnit(Guid.Empty, Guid.Empty);
		}


		#endregion


		#region properties

				
		[Test]
		public void CurrentCrossmatchResultCode_Pass()
		{
			string tstValue = this._orderedUnit.CurrentCrossmatchResultCode;

			Assert.AreEqual(tstValue, this._orderedUnit.CurrentCrossmatchResultCode);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void CurrentCrossmatchResultCode_Fail()
		{
		}

		[Test]
		public void CurrentCrossmatchTechId_Pass()
		{
			string tstValue = this._orderedUnit.CurrentCrossmatchTechId;

			Assert.AreEqual(tstValue, this._orderedUnit.CurrentCrossmatchTechId);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void CurrentCrossmatchTechId_Fail()
		{
		}

		[Test]
		public void CurrentCrossmatchDate_Pass()
		{
			System.DateTime tstValue = this._orderedUnit.CurrentCrossmatchDate;

			Assert.AreEqual(tstValue, this._orderedUnit.CurrentCrossmatchDate);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void CurrentCrossmatchDate_Fail()
		{
		}

		[Test]
		public void OrderedUnitGuid_Get()
		{
			Guid orderedUnitGuid = _orderedUnit.OrderedUnitGuid;
			Assert.IsTrue(orderedUnitGuid == _orderedUnit.OrderedUnitGuid);
		}
		[Test]
		public void OrderedUnitGuid_Set()
		{
			Guid orderedUnitGuid = Guid.NewGuid();
			_orderedUnit.OrderedUnitGuid = orderedUnitGuid;
			Assert.IsTrue(orderedUnitGuid == _orderedUnit.OrderedUnitGuid);
		}

		[Test]
		public void OrderedComponentGuid_Get()
		{
			Guid orderedComponentGuid = _orderedUnit.OrderedComponentGuid;
			Assert.IsTrue(orderedComponentGuid == _orderedUnit.OrderedComponentGuid);
		}
		[Test]
		public void OrderedComponentGuid_Set()
		{
			Guid orderedComponentGuid = Guid.NewGuid();
			_orderedUnit.OrderedComponentGuid = orderedComponentGuid;
			Assert.IsTrue(orderedComponentGuid == _orderedUnit.OrderedComponentGuid);
		}

		[Test]
		public void OrderedTestGuid_Get()
		{
			Guid orderedTestGuid = _orderedUnit.OrderedTestGuid;
			Assert.IsTrue(orderedTestGuid == _orderedUnit.OrderedTestGuid);
		}
		[Test]
		public void OrderedTestGuid_Set()
		{
			Guid orderedTestGuid = Guid.NewGuid();
			_orderedUnit.OrderedTestGuid = orderedTestGuid;
			Assert.IsTrue(orderedTestGuid == _orderedUnit.OrderedTestGuid);
		}

		[Test]
		public void BloodUnitGuid_Get()
		{
			Guid bloodUnitGuid = _orderedUnit.BloodUnitGuid;
			Assert.IsTrue(bloodUnitGuid == _orderedUnit.BloodUnitGuid);
		}
		[Test]
		public void BloodUnitGuid_Set()
		{
			Guid bloodUnitGuid = Guid.NewGuid();
			_orderedUnit.BloodUnitGuid = bloodUnitGuid;
			Assert.IsTrue(bloodUnitGuid == _orderedUnit.BloodUnitGuid);
		}

		[Test]
		public void SelectedDate_Get()
		{
			DateTime selectedDate = _orderedUnit.SelectedDate;
			Assert.IsTrue(selectedDate == _orderedUnit.SelectedDate);
		}
		[Test]
		public void SelectedDate_Set()
		{
			DateTime selectedDate = DateTime.Now;
			_orderedUnit.SelectedDate = selectedDate;
			Assert.IsTrue(selectedDate == _orderedUnit.SelectedDate);
		}

		[Test]
		public void CrossmatchDate_Get()
		{
			DateTime crossmatchDate = _orderedUnit.CrossmatchDate;
			Assert.IsTrue(crossmatchDate == _orderedUnit.CrossmatchDate);
		}
		[Test]
		public void CrossmatchDate_Set()
		{
			DateTime crossmatchDate = DateTime.Now;
			_orderedUnit.CrossmatchDate = crossmatchDate;
			Assert.IsTrue(crossmatchDate == _orderedUnit.CrossmatchDate);
		}

		[Test]
		public void CrossmatchResultCode_Get()
		{
			string crossmatchResultCode = _orderedUnit.CrossmatchResultCode;
			Assert.IsTrue(crossmatchResultCode == _orderedUnit.CrossmatchResultCode);
		}
		[Test]
		public void CrossmatchResultCode_Set()
		{
			string crossmatchResultCode = "ZZZ";
			_orderedUnit.CrossmatchResultCode = crossmatchResultCode;
			Assert.IsTrue(crossmatchResultCode == _orderedUnit.CrossmatchResultCode);
		}

		[Test]
		public void CrossmatchRequiredIndicator_Get()
		{
			bool crossmatchRequiredIndicator = _orderedUnit.CrossmatchRequiredIndicator;
			Assert.IsTrue(crossmatchRequiredIndicator == _orderedUnit.CrossmatchRequiredIndicator);
		}
		[Test]
		public void CrossmatchRequiredIndicator_Set()
		{
			bool crossmatchRequiredIndicator = true;
			_orderedUnit.CrossmatchRequiredIndicator = crossmatchRequiredIndicator;
			Assert.IsTrue(crossmatchRequiredIndicator == _orderedUnit.CrossmatchRequiredIndicator);
		}

		[Test]
		public void CrossmatchTechId_Get()
		{
			string crossmatchTechId = _orderedUnit.CrossmatchTechID;
			Assert.IsTrue(crossmatchTechId == _orderedUnit.CrossmatchTechID);
		}
		[Test]
		public void CrossmatchTechId_Set()
		{
			string crossmatchTechId = "ZZZ";
			_orderedUnit.CrossmatchTechID = crossmatchTechId;
			Assert.IsTrue(crossmatchTechId == _orderedUnit.CrossmatchTechID);
		}

		[Test]
		public void ReleaseDate_Get()
		{
			DateTime releaseDate = _orderedUnit.ReleaseDate;
			Assert.IsTrue(releaseDate == _orderedUnit.ReleaseDate);
		}
		[Test]
		public void ReleaseDate_Set()
		{
			DateTime releaseDate = DateTime.Now;
			_orderedUnit.ReleaseDate = releaseDate;
			Assert.IsTrue(releaseDate == _orderedUnit.ReleaseDate);
		}

		[Test]
		public void DivisionCode_Get()
		{
			string divisionCode = _orderedUnit.DivisionCode;
			Assert.IsTrue(divisionCode == _orderedUnit.DivisionCode);
		}
		[Test]
		public void DivisionCode_Set()
		{
			string divisionCode = "ZZZ";
			_orderedUnit.DivisionCode = divisionCode;
			Assert.IsTrue(divisionCode == _orderedUnit.DivisionCode);
		}

		[Test]
		public void RecordStatusCode_Get()
		{
			Common.RecordStatusCode rCS = _orderedUnit.RecordStatusCode;
			Assert.IsTrue(rCS == _orderedUnit.RecordStatusCode);
		}
		[Test]
		public void RecordStatusCode_Set()
		{
			Common.RecordStatusCode rCS = Common.RecordStatusCode.Active;
			_orderedUnit.RecordStatusCode = rCS;
			Assert.IsTrue(rCS == _orderedUnit.RecordStatusCode);
		}

		[Test]
		public void LastUpdateDate_Get()
		{
			DateTime lastUpdateDate = _orderedUnit.LastUpdateDate;
			Assert.IsTrue(lastUpdateDate == _orderedUnit.LastUpdateDate);
		}
		[Test]
		public void LastUpdateDate_Set()
		{
			DateTime lastUpdateDate = DateTime.Now;
			_orderedUnit.LastUpdateDate = lastUpdateDate;
			Assert.IsTrue(lastUpdateDate == _orderedUnit.LastUpdateDate);
		}

		[Test]
		public void LastUpdateUser_Get()
		{
			string lastUpdateUser = _orderedUnit.LastUpdateUser;
			Assert.IsTrue(lastUpdateUser == _orderedUnit.LastUpdateUser);
		}
		[Test]
		public void LastUpdateUser_Set()
		{
			string lastUpdateUser = "ZZZ";
			_orderedUnit.LastUpdateUser = lastUpdateUser;
			Assert.IsTrue(lastUpdateUser == _orderedUnit.LastUpdateUser);
		}

		[Test]
		public void RowVersion_Get()
		{
			byte[] rowVersion = _orderedUnit.RowVersion;
			Assert.IsTrue(rowVersion == _orderedUnit.RowVersion);
		}
		[Test]
		[Ignore( StandardIgnoreReasons.ReadOnlyProperty )]
		public void RowVersion_Set()
		{
		}

		[Test]
		public void SelectedTechId_Get()
		{
			string selectedTechId = _orderedUnit.SelectedTechId;
			Assert.IsTrue( selectedTechId == _orderedUnit.SelectedTechId );
		}
		[Test]
		public void SelectedTechId_Set()
		{
			string selectedTechId = "ZZZ";
			_orderedUnit.SelectedTechId = selectedTechId;
			Assert.IsTrue( selectedTechId == _orderedUnit.SelectedTechId );
		}

		[Test]
		public void ReleaseTechId_Pass()
		{
			// Get
			string releaseTechId = _orderedUnit.ReleaseTechId;
			Assert.IsTrue( releaseTechId == _orderedUnit.ReleaseTechId );
			//
			// Set
			releaseTechId = "ZZZ";
			_orderedUnit.ReleaseTechId = releaseTechId;
			Assert.IsTrue( releaseTechId == _orderedUnit.ReleaseTechId );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReleaseTechId_Fail()
		{
		}

		#endregion


		#region methods

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IncompatibleCrossmatchResultsExist_Pass()
		{
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IncompatibleCrossmatchResultsExist_Fail()
		{
		}

		[Test]
		public void GetOrderedUnit_Pass()
		{
			DataTable dt = OrderedUnit.GetOrderedUnit(_bloodUnitGuid, UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(dt.Rows.Count > 0, "Rows.Count");
		}
		[Test]
		public void GetOrderedUnit_Fail()
		{
			DataTable dt = OrderedUnit.GetOrderedUnit(Guid.NewGuid(), string.Empty);
			Assert.AreEqual(0, dt.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetOrderedUnitData_Pass()
		{
			DataTable dt = OrderedUnit.GetOrderedUnitData(_bloodUnitGuid.ToString(), _patientGuid);
			Assert.IsTrue(dt.Rows.Count > 0, "Rows.Count");
		}
		[Test]
		public void GetOrderedUnitData_Fail()
		{
			DataTable dt = OrderedUnit.GetOrderedUnitData(Guid.Empty.ToString(), Guid.Empty);
			Assert.AreEqual(0, dt.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetHistoricalOrderedUnits_Pass()
		{
			DataTable dt = OrderedUnit.GetHistoricalOrderedUnits(_bloodUnitGuid, UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(dt.Rows.Count > 0, "Rows.Count");
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetHistoricalOrderedUnits_Fail()
		{
			DataTable dt = OrderedUnit.GetHistoricalOrderedUnits(Guid.NewGuid(), string.Empty);
			Assert.AreEqual(0, dt.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetOrderedUnitByComponent_Pass()
		{
			DataTable dt = OrderedUnit.GetOrderedUnitByComponent(_orderedComponentGuid, UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(dt.Rows.Count >= 0, "Rows.Count");
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetOrderedUnitByComponent_Fail()
		{
			DataTable dt = OrderedUnit.GetOrderedUnitByComponent(Guid.Empty, UnitTestConfig.TestDivisionCode);
		}

		[Test]
		public void GetOrderedUnitCount_Pass()
		{
			int count = BOL.OrderedUnit.GetOrderedUnitCount(_orderedComponentGuid, UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(count >= 0);
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetOrderedUnitCount_Fail()
		{
			int count = BOL.OrderedUnit.GetOrderedUnitCount(Guid.Empty, string.Empty);
			Assert.IsTrue(count == 0);
		}

		[Test]
		public void GetOrderedUnitsForPatient_Pass()
		{
			DataTable dt = BOL.OrderedUnit.GetOrderedUnitsForPatient(_patientGuid);
			Assert.IsTrue(dt.Rows.Count >= 0, "Units returned");

			dt = BOL.OrderedUnit.GetOrderedUnitsForPatient(Guid.NewGuid());
			Assert.AreEqual(0, dt.Rows.Count, "No units returned");
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetOrderedUnitsForPatient_Fail()
		{
			DataTable dt = BOL.OrderedUnit.GetOrderedUnitsForPatient(Guid.Empty);
		}
		
		[Test]
		public void GetOrderedUnitsForSpecimen_Pass()
		{
			ArrayList al = BOL.OrderedUnit.GetOrderedUnitsForSpecimen(_patientSpecimenGuid);
			Assert.IsTrue(al.Count >= 0, "Units returned");

			al = BOL.OrderedUnit.GetOrderedUnitsForSpecimen(Guid.NewGuid());
			Assert.AreEqual(0, al.Count, "No units returned");
		}
		[Test]
		[ExpectedExceptionAttribute(typeof(ArgumentException))]
		public void GetOrderedUnitsForSpecimen_Fail()
		{
			BOL.OrderedUnit.GetOrderedUnitsForSpecimen(Guid.Empty);
		}

		[Test]
		public void GetOrderedUnitsForUnit_Pass()
		{
			DataTable dt = BOL.OrderedUnit.GetOrderedUnitsForUnit();
			Assert.IsTrue(dt.Rows.Count > 0, "Units returned");
		}
		[Test]
		[Ignore( StandardIgnoreReasons.NoFailureConditions )]
		public void GetOrderedUnitsForUnit_Fail()
		{
		}

		[Test]
		public void GetOrderedUnitsForRepeatXM_Pass()
		{
			// build the sql query string
			string sSQL = "SELECT TOP 1 OrderedComponentGuid FROM PatientOrder INNER JOIN";
			sSQL = sSQL + " OrderedComponent ON PatientOrder.PatientOrderGuid = OrderedComponent.PatientOrderGuid";
			sSQL = sSQL + " WHERE EXISTS (Select 1 FROM OrderedUnit";
			sSQL = sSQL + " WHERE OrderedUnit.OrderedComponentGuid = OrderedComponent.OrderedComponentGuid";
			sSQL = sSQL + " AND OrderedUnit.CrossmatchRequiredIndicator = 1)";

			// instantiate the Connection and Command object
			System.Guid orderedComponentGUID = DataCreator.GetRecordGuid(sSQL);

			if (orderedComponentGUID != Guid.Empty)
			{
				DataTable dt = BOL.OrderedUnit.GetOrderedUnitsForRepeatXM(Guid.Empty, orderedComponentGUID);
				Assert.IsTrue(dt.Rows.Count >= 0, "Rows.Count");
			}
		}

		[Test]
		public void GetOrderedUnitsForRepeatXM_Fail()
		{
			DataTable dt = BOL.OrderedUnit.GetOrderedUnitsForRepeatXM(Guid.NewGuid(), Guid.Empty);
			Assert.AreEqual(0, dt.Rows.Count, "Rows.Count");
		}

		[Test]
		public void InitializeOrderedUnitTable_Pass()
		{
			DataTable dt = BOL.OrderedUnit.InitializeOrderedUnitTable();
			Assert.IsTrue(dt.Columns.Count > 0);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InitializeOrderedUnitTable_Fail()
		{
		}

		[Test]
		public void GetOrderedUnitDataTableForReleaseOfPatientAssignment_Pass()
		{
			DataRow drPatient = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = (Guid)drPatient[TABLES.Patient.PatientGuid];
			//
			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), Guid.Empty, bloodProductGuid, isCodabar);

			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid patientSpecimenGuid = Guid.NewGuid();
			DataCreator.InsertPatientSpecimen(patientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			DataCreator.InsertOrderedTest(orderedTestGuid, patientOrderGuid, patientSpecimenGuid, Common.OrderableTest.RepeatXM);

			Guid orderedUnitGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);
			//
			ArrayList orderedUnits = new ArrayList(1);
			orderedUnits.Add(new BloodUnit(bloodUnitGuid, bloodProductGuid));
			DataTable dt = BOL.OrderedUnit.GetOrderedUnitDataTableForReleaseOfPatientAssignment(orderedUnits,DateTime.Now,Environment.UserName);
			Assert.AreEqual(7,dt.Columns.Count,"Columns.Count");
			Assert.AreEqual(1,dt.Rows.Count,"Rows.Count");
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetOrderedUnitDataTableForReleaseOfPatientAssignment_Fail()
		{
		}

		[Test]
		public void GetAssignedUnits_Pass()
		{
			_assignedUnits = OrderedUnit.GetAssignedUnits();
			Assert.IsTrue(_assignedUnits.Count > 0, "Assigned unit count < 1");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAssignedUnits_Fail()
		{
		}

		[Test]
		public void ReleaseOrderedUnits_Pass()
		{
			DataRow drPatient = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = (Guid)drPatient[TABLES.Patient.PatientGuid];
			//
			Guid bloodUnitGuid = Guid.NewGuid();
			Guid expiredUnitGuid = Guid.NewGuid();

			Guid bloodProductGuid = DataCreator.GetRandomBloodProduct(true, Common.ComponentClass.RBC).BloodProductGuid;
			DataCreator.CreateBloodUnit(bloodUnitGuid, Guid.NewGuid(), Guid.Empty, bloodProductGuid, true);
			DataCreator.CreateBloodUnit(expiredUnitGuid, Guid.NewGuid(), Guid.Empty, bloodProductGuid, true);

			//Expire the BloodUnit - for code coverage
			UnitTestUtil.RunSQL("UPDATE BloodUnitMedia SET UnitExpirationDate = '04-20-1974' WHERE BloodUnitGuid = '" + expiredUnitGuid.ToString() + "'");

			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, COMMON.ComponentClass.RBC, 2);

			Guid patientSpecimenGuid = Guid.NewGuid();
			DataCreator.InsertPatientSpecimen(patientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			DataCreator.InsertOrderedTest(orderedTestGuid, patientOrderGuid, patientSpecimenGuid, COMMON.OrderableTest.RepeatXM);

			Guid orderedUnitGuid = Guid.NewGuid();
			Guid expiredOUGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);
			DataCreator.InsertOrderedUnit(expiredOUGuid, orderedComponentGuid, expiredUnitGuid);

			ArrayList orderedUnits = BOL.OrderedUnit.GetAssignedUnits();
			ArrayList records = new ArrayList(1);
			foreach (Hashtable dr in orderedUnits)
			{
				if (dr[TABLES.OrderedUnit.OrderedUnitGuid].ToString() == orderedUnitGuid.ToString())
				{
					records.Add(dr);
				}
				if (dr[TABLES.OrderedUnit.OrderedUnitGuid].ToString() == expiredOUGuid.ToString())
				{
					records.Add(dr);
				}
			}
			ArrayList expiredUnits = new ArrayList();

			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ReleaseUnitFromPatientBackToInventory);
			Assert.AreEqual(true,BOL.OrderedUnit.ReleaseOrderedUnits(records,DateTime.Now,Environment.UserName,"Unit TEST 4018",ref expiredUnits,Common.WorkloadProcessID.ReleaseUnitFromPatientBackToInventory, null),"ReleaseUnit");
		}


		[Test]
		[ExpectedExceptionAttribute(typeof(NullReferenceException))]
		public void ReleaseOrderedUnits_Fail()
		{
			ArrayList expiredUnits = null;
			DataCreator.CreateWorkloadProcess(Common.WorkloadProcessID.ReleaseUnitFromPatientBackToInventory);
			Assert.IsTrue(OrderedUnit.ReleaseOrderedUnits(null, new DateTime(), null, null, ref expiredUnits, Common.WorkloadProcessID.ReleaseUnitFromPatientBackToInventory,null), "Units not released");
		}

		
		[Test]
		public void ReleaseOrderedUnits_BloodUnit_andmore_Pass()
		{
			DataRow drPatient = UnitTestUtil.RunSQLGetDataRow("SELECT TOP 1 * FROM Patient ORDER BY LastUpdateDate DESC");
			Guid patientGuid = (Guid)drPatient[TABLES.Patient.PatientGuid];
			//
			DataTable dtProduct = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM BloodProduct WHERE ProductTypeCode = 'E002' AND RecordStatusCode = 'A' ORDER BY LastUpdateDate DESC");
			System.Guid bloodUnitGuid = System.Guid.NewGuid();
			System.Guid bloodProductGuid = (System.Guid)dtProduct.Rows[0][TABLES.BloodProduct.BloodProductGuid];
			bool isCodabar = (dtProduct.Rows[0][TABLES.BloodProduct.ProductCodeIndicator].ToString() == "0");
			DataCreator.CreateBloodUnit(bloodUnitGuid, System.Guid.NewGuid(), Guid.Empty, bloodProductGuid, isCodabar);

			Guid patientTreatmentGuid = Guid.NewGuid();
			DataCreator.InsertPatientTreatment(patientTreatmentGuid, patientGuid);

			Guid patientOrderGuid = Guid.NewGuid();
			DataCreator.InsertPatientOrder(patientOrderGuid, patientTreatmentGuid);

			Guid orderedComponentGuid = Guid.NewGuid();
			DataCreator.InsertOrderedComponent(orderedComponentGuid, patientOrderGuid, Common.ComponentClass.RBC, 2);

			Guid patientSpecimenGuid = Guid.NewGuid();
			DataCreator.InsertPatientSpecimen(patientSpecimenGuid, patientGuid, false);

			Guid orderedTestGuid = Guid.NewGuid();
			DataCreator.InsertOrderedTest(orderedTestGuid, patientOrderGuid, patientSpecimenGuid, Common.OrderableTest.RepeatXM);

			Guid orderedUnitGuid = Guid.NewGuid();
			DataCreator.InsertOrderedUnit(orderedUnitGuid, orderedComponentGuid, bloodUnitGuid);

			Assert.IsTrue(BOL.OrderedUnit.ReleaseOrderedUnits(new BOL.BloodUnit(bloodUnitGuid, bloodProductGuid),"Unit TEST 7245",DateTime.Now,Environment.UserName,Common.UpdateFunction.UnitTests,null),"ReleaseUnit");
		}

		
		[Test]
		[ExpectedException(typeof(NullReferenceException))]
		public void ReleaseOrderedUnits_BloodUnit_andmore_Fail()
		{
			Assert.AreEqual(false,BOL.OrderedUnit.ReleaseOrderedUnits(null,null,DateTime.MinValue,null,Common.UpdateFunction.UnitTests,null),"Release Fails");
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{
			bool results = true;
			//
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 * FROM OrderedUnit" );
			//
			BOL.OrderedUnit ou = new OrderedUnit( dr );
			//
			dr = ou.LoadDataRowFromThis( dr );
			//
			try
			{
				Common.Utility.RequireNonNullColumns( dr.Table, Common.VbecsStoredProcs.UpdateOrderedUnit.RequiredParameters );
			}
			catch (Exception)
			{
				results = false;
			}
			Assert.IsTrue( results );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		#endregion
	}
}
#endif





